local mainButtonFont = "_francophilsans Bold 24px"
local modButtonFont = "_dejavu sans Bold 24px"

local NumpadMap = {
	{ "1", "2", "3", "<", nil			 }, -- impossible to get to top right
	{ "4", "5", "6", ".", "NumPadOK"	 },
	{ "7", "8", "9", "0", "NumPadCancel" },
}

local function numButton(n)
	return Def.ActorFrame{
		Name="NumPad"..n;

		LoadActor(THEME:GetPathG("_speedmod","numitem"))..{
			Name="Button";
		};
		LoadFont(modButtonFont)..{
			Name="Text";
			Text=n;
			InitCommand=cmd(shadowlength,2;zoom,20/24);
			-- fix the positioning of the backspace character:
			BeginCommand=function(self) if n == "<" then self:x(-1) self:y(-2) end end;
		};
	};
end

return Def.ActorFrame{
	Def.ActorFrame{
		Name="ModTypeButtons";
		InitCommand=cmd(xy,SCREEN_CENTER_X+48,SCREEN_CENTER_Y-36;);

		Def.ActorFrame{
			Name="xMod";
			InitCommand=cmd(x,-108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"xMod");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};

		Def.ActorFrame{
			Name="cMod";
			InitCommand=cmd(x,0;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"C-Mod");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};

		Def.ActorFrame{
			Name="mMod";
			InitCommand=cmd(x,108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"m-Mod");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
	};

	-- the number pad
	Def.ActorFrame{
		Name="NumPad";
		InitCommand=cmd(xy,SCREEN_CENTER_X+54,SCREEN_CENTER_Y+16;);
		-- row 1
		numButton("1")..{ InitCommand=cmd(xy,-120,0;);	};
		numButton("2")..{ InitCommand=cmd(xy,-80,0;);	};
		numButton("3")..{ InitCommand=cmd(xy,-40,0;);	};
		numButton("<")..{ InitCommand=cmd(xy,0,0;);		};
		-- row 2
		numButton("4")..{ InitCommand=cmd(xy,-120,40;);	};
		numButton("5")..{ InitCommand=cmd(xy,-80,40;);	};
		numButton("6")..{ InitCommand=cmd(xy,-40,40;);	};
		numButton(".")..{ InitCommand=cmd(xy,0,40;);	};
		-- row 3
		numButton("7")..{ InitCommand=cmd(xy,-120,80;);	};
		numButton("8")..{ InitCommand=cmd(xy,-80,80;);	};
		numButton("9")..{ InitCommand=cmd(xy,-40,80;);	};
		numButton("0")..{ InitCommand=cmd(xy,0,80;);	};

		-- buttons
		Def.ActorFrame{
			Name="NumPadOK";
			InitCommand=cmd(xy,76,40;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"OK");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
		Def.ActorFrame{
			Name="NumPadCancel";
			InitCommand=cmd(xy,76,80;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Cancel");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
	};
};